<?php

namespace App\Http\Controllers\Api\User;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User,App\SubService;
use Validator;


class ProfileController extends Controller
{
	public function getUserInfo($user_id)
	{
		$user = User::find($user_id);
		if (count($user) > 0) {
			if ($user->type_user == "user" ) {
		
			return response()->json(['status'=>'1','user'=>$user]);
			}
		}else{
			return response()->json(['status'=>'0','message'=>'البيانات المطلوبه غير موجوده']);
		}
	}

	public function UserUpdate($user_id,Request $request)
	{
		$validator = Validator::make($data = $request->all(), 
    	[
            'email'=>'required|email',
            'name'=>'required',
            'lat_location'=>'required',
            'long_location'=>'required',
            // 'time_work'=>'required',
		]);
    	
		if($validator->fails()){
    		return response()->json(['status'=>'0','errors'=>$validator->errors()->all()]);
        }

        if ($request->has('password')) {
        	$update = User::find($user_id)->update($request->all());
        	$password = User::find($user_id)->update([
        		'password'=>bcrypt($request->get('password'))
        		]);
        }else{
        	$update = User::find($user_id)->update($request->except('password'));
        }
        if ($request->has('image')) {
        	$time = time();
			$fullname = $time . '.png';
			$image = "data:image/jpg;base64,".$request->get('image');
			$img = substr($request->get('image'), strpos($request->get('image'), ",")+1);
			$binary  = base64_decode($img);

			$put_file = file_put_contents(public_path().'/uploads/images/profile/'. $fullname, base64_decode(explode(',',$image)[1]));
			$this->attributes['image'] ='uploads/images/profile/'.$fullname;
			$update_user = User::find($user_id)->update([
				'image'=>$this->attributes['image'],
				]);		
        }
		return response()->json(['status'=>'1','message'=>'تم تحديث البيانت بنجاح']);

	}
}
