<?php

namespace App\Http\Controllers\Api\Salons;	

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use App\Service;
use Response;
use GoogleSpeech\TextToSpeech;
use App\SubService;
use DB;
use Illuminate\Support\Collection;

class servicesController extends Controller
{
	public function TextToSpeach()
	{

		$speech = new TextToSpeech();
		$speech->withLanguage('ar')->inPath(public_path().'/uploads/audio');

		    $speech->withName('مولانا الإمام 2');
		    $speech->download(' 
		     ..  إنا نريد منكم الإنضمام لفريق دعاتنا .. انتظر منا مكالمة تليفونية في القريب العاجل .. والله ولي التوفيق');
		    
		    echo 'File generated:' . $speech->getCompletePath() . '<br>';
		
	}


	//list main services  
	public function index(Request $request)
	{
		$services  =Service::orderBy('created_at','DESC')->get();
		if (count($services)) {
	        $response["status"] = ["success" => 1,'result'=>$services ];			
	        return Response::json($response);
		}else{	
			$message = "البيانات المطلوبه غير موجوده";
	        $response["status"] = ["success" => 0,'message'=>$message ];			
	        return Response::json($response);
		}
	}

	public function get_salone_use_service($service_id)
	{
		$salons = SubService::where('service_id',$service_id)
								// ->select('id','service_id','salone_id')
								->groupBy('salone_id')
								->with('salons')
								->get();
		if (count($salons) > 0) {
			return response()->json(['status'=>'1','service'=>$salons]);
		}else{
			return response()->json(['status'=>'0','meessag'=>'البيانات المطلوبه غير موجوده']);
		}
	}

		public function get_sub_service($service_id,$salone_id)
	{
		$salons = SubService::where('service_id',$service_id)->where('salone_id',$salone_id)
								// ->select('id','service_id','salone_id')
								// ->groupBy('service_id')
								// ->with('salons')
								->get();
		if (count($salons) > 0) {
			return response()->json(['status'=>'1','service'=>$salons]);
		}else{
			return response()->json(['status'=>'0','meessag'=>'البيانات المطلوبه غير موجوده']);
		}
	}
	public function store(Request $request,$salone_id)
	{
		   $validator = Validator::make($data = $request->all(), 
    	[
			'name'=>'required',
            'icon'=>'required',
		]);
    	
		if($validator->fails()){
	        $response["status"] = ["success" => 0,'errors'=>$validator->errors()->all() ];			
	        return Response::json($response);
        }

		$create = Service::create($request->except('icon'));
		$add_salon_id = Service::find($create->id)->update(['salone_id'=>$salone_id]);
		if ($request->has('icon')) {
			$time = time();
			$fullname = $time .'.png';
			$image = "data:image/jpg;base64,".$request->get('icon');
			$img = substr($request->get('icon'), strpos($request->get('icon'), ",")+1);
			$binary  = base64_decode($img);
			$put_file = file_put_contents(public_path().'/uploads/images/services/'. $fullname, base64_decode(explode(',',$image)[1]));
			$this->attributes['icon'] = '/uploads/images/services/'.$fullname;
			$icon = Service::find($create->id)->update(['icon'=>$this->attributes['icon']]);
		}

		$message = "تم إضافة خدمه جديده";
        $response["status"] = ["success" => 1,'message'=>$message ];			
        return Response::json($response);
	}
}
