<?php

namespace App\Http\Controllers\Api\Salons;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\SubService;
use Validator;
use Response;

class SubServicesController extends Controller
{
	public function index($main_service_id)
	{
		$services  =SubService::where('service_id',$main_service_id)->with('service')->orderBy('created_at','DESC')->get();
		if (count($services)) {
	        $response["status"] = ["success" => 1,'result'=>$services ];			
	        return Response::json($response);
		}else{	
			$message = "البيانات المطلوبه غير موجوده";
	        $response["status"] = ["success" => 0,'message'=>$message ];			
	        return Response::json($response);
		}
	}
	public function store(Request $request)
	{
		$validator = Validator::make($data = $request->all(), 
    	[
			'name'=>'required',
            'service_id'=>'required',
            'salone_id'=>'required',
            'time'=>'required',
            'price'=>'required'
		]);
    	
		if($validator->fails()){			
	        $response["status"] = ["success" => 0,'errors'=>$validator->errors()->all()];			
	        return Response::json($response);
        }

        $create = SubService::create($request->all());

		$message = "تم إضافة خدمه جديده";
        $response["status"] = ["success" => 1,'message'=>$message ];			
        return Response::json($response);
	}

	public function edit($service_id)
	{
		$find_service = SubService::where('id',$service_id)->with('user')->with('service')->first();
		if (count($find_service)) {
			$response["status"] = ["success" => 1,'result'=>$find_service ];			
	        return Response::json($response);
		}else{
			$message = "البيانات المطلوبه غير موجوده";
	        $response["status"] = ["success" => 0,'message'=>$message ];			
	        return Response::json($response);
		}
	}
	public function update($service_id , Request $request)
	{
		$validator = Validator::make($data = $request->all(), 
    	[
			'name'=>'required',
            'service_id'=>'required',
            'salone_id'=>'required',
            'time'=>'required',
            'price'=>'required'
		]);
    	
		if($validator->fails()){			
	        $response["status"] = ["success" => 0,'errors'=>$validator->errors()->all()];			
	        return Response::json($response);
        }

        $update = SubService::find($service_id)->update($request->all());

		$message = "تم تعديل بيانات الخدمه";
        $response["status"] = ["success" => 1,'message'=>$message ];			
        return Response::json($response);
	}


	public function destroy($service_id)
	{
		$delete = SubService::destroy($service_id); 
		$message = "تم حذف بيانات الخدمه";
        $response["status"] = ["success" => 1,'message'=>$message ];			
        return Response::json($response);
	}
}
