<?php

namespace App\Http\Controllers\Api\Base;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use App\ContactUs;
use App\ContactUsSetting;
use Mail;
use Response;
class ContactusController extends Controller
{
	public function map(Request $request)
	{
		$info = ContactUsSetting::first(['lat','long']);
		if(count($info) > 0 ){
			$response["Status"] = ["succeed" => 1, "Latitude" =>$info->lat,'Longitude'=>$info->long ];
		}else{
			$msg = $request->get('lang') == "en" ? ['required data does not exist']:['البيانات المطلوبه غير موجوده'];
			
			$response["Status"] = ["fail" => 0,'message'=>$msg ];			
		}
		return Response::json($response);
	}
    public function contactUs(Request $request)
    {
		$data = $data = $request->all();
    	$validator = Validator::make($data ,
    	[
			'name'=>'required',
			'email'=>'required|email',
			'message'=>'required',
		]);

		if ($validator->fails()) {
			$status = 0;
			$msg = $validator->errors()->all();
		} else {
			$insert = ContactUs::create($request->all());
			$name = $insert->name;
			$email = $insert->email;
			$mms = $request->get('message');
			Mail::send('email.email', ['email' => $email,'name'=>$name ,'mms' =>$mms], function ($message) use ($insert)
			{
				$message->from('no-reply@brand4it.com', 'Support.brand4it.com');
				$message->to($insert->email)->subject('Contact us');
			});
			$status = 1;
			$msg = $request->get('lang') == "en" ? ['check your email with feedback']:['يرجى متابعه حسابك اﻻلكترونى'];
		}

		$response["Status"] = ["succeed" => $status, "message" => $msg];
		return Response::json($response);
	}
}
