<?php

namespace App\Http\Controllers\Api\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Validator;

class RegesterController extends Controller
{
    public function signup(Request $request)
    {
        $validator = Validator::make($data = $request->all(), 
    	[
			'name'=>'required|unique:users',
			'email'=>'required|email|unique:users',
            'password'=>'required',
            'type_user'=>'required'
		]);
    	
		if($validator->fails()){
    		return response()->json(['status'=>'0','errors'=>$validator->errors()->all()]);
        }
        
        $check_username = User::where('name',$request->get('name'))->orWhere('email',$request->get('email'))->get();
        if(count($check_username) > 0){
    		return response()->json(['status'=>'2','errors'=>'should be username & email uniqe']);
        }else{
          $create = User::create([
                'name'=>$request->get('name'),
                'email'=>$request->get('email'),
                'password'=>bcrypt($request->get('password')),
                'type_user'=>$request->get('type_user'),
            ]);
            return response()->json(['status'=>'1','success'=>'account created!','user_id'=>$create->id]);
        }

    }
}
