<?php

namespace App\Http\Controllers\Api\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User,App\SubService;
use Validator;
use DB;

class ProfileUpdateController extends Controller
{
	public function getSalonInfo($salone_id)
	{
		$user = User::find($salone_id);
		if (count($user) > 0) {
			if ($user->type_user == "salon" || $user->type_user == "family") {
		
			$services =  DB::table('services')
						            ->join('sub_services', 'services.id', '=', 'sub_services.service_id')
						            ->where('sub_services.salone_id',$salone_id)
						            ->select('services.id','services.name','services.icon')
						            ->distinct()
						            ->get();
					// dd($services);		
			return response()->json(['status'=>'1','user'=>$user,'service'=>$services]);
			}
		}else{
			return response()->json(['status'=>'0','message'=>'البيانات المطلوبه غير موجوده']);
		}
	}

	public function SalonUpdate($salone_id,Request $request)
	{
		 $validator = Validator::make($data = $request->all(), 
    	[
            'email'=>'required|email',
            'name'=>'required',
            'lat_location'=>'required',
            'long_location'=>'required',
            'time_work'=>'required',
		]);
    	
		if($validator->fails()){
    		return response()->json(['status'=>'0','errors'=>$validator->errors()->all()]);
        }

        if ($request->has('password')) {
        	$update = User::find($salone_id)->update($request->all());
        	$password = User::find($user_id)->update([
        		'password'=>bcrypt($request->get('password'))
        		]);
        }else{
        	$update = User::find($salone_id)->update($request->except('password'));
        }
        if ($request->has('image')) {
        	$time = time();
			$fullname = $time . '.png';
			$image = "data:image/jpg;base64,".$request->get('image');
			$img = substr($request->get('image'), strpos($request->get('image'), ",")+1);
			$binary  = base64_decode($img);

			$put_file = file_put_contents(public_path().'/uploads/images/profile/'. $fullname, base64_decode(explode(',',$image)[1]));
			$this->attributes['image'] ='uploads/images/profile/'.$fullname;
			$update_user = User::find($salone_id)->update([
				'image'=>$this->attributes['image'],
				]);		
        }
		return response()->json(['status'=>'1','message'=>'تم تحديث البيانت بنجاح']);

	}

}
