<?php

namespace App\Http\Controllers\Api\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Hash;
use Validator;

class LoginController extends Controller
{
    public function PostLogin(Request $request)
    {
        $validator = Validator::make($data = $request->all(), 
    	[
			'user'=>'required',
            'password'=>'required',
		]);
    	
		if($validator->fails()){
    		return response()->json(['status'=>'0','errors'=>$validator->errors()->all()]);
        }
        $find_user = User::where('name',$request->get('user'))
                            ->whereIn('type_user', array('user', 'car', 'workshop'))
                            ->orWhere('email',$request->get('user'))
                            ->first();

        if(count($find_user) > 0){
            //check password
            if (Hash::check($request->get('password'), $find_user->password)) {
                if($request->get('lang') == 'en'){
                    return response()->json(['status'=>'1','succes'=>'auth successfuly!','user'=>$find_user]);
                }else{
                    return response()->json(['status'=>'1','succes'=>'تم تسجيل الدخول بنجاح!','user'=>$find_user]);                
                }
            }else{
                if($request->get('lang') == 'en'){
                    return response()->json(['status'=>'2','error'=>'auth failure!']);
                }else{
                    return response()->json(['status'=>'2','succes'=>'فشل تسجيل الدخول!']);                
                }
            }
        }else{
            //user user info  if not found will see this message
            if($request->get('lang') == 'en'){
                return response()->json(['status'=>'2','error'=>'auth failure!']);
            }else{
                return response()->json(['status'=>'2','succes'=>'فشل تسجيل الدخول!']);                
            }
        }
       
    }
}
