<?php

namespace App\Http\Controllers\Api\Auth;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Hash;
use Validator;
use Mail;

class ForgetPasswordController extends Controller
{
    /*
    *******************
    *check email user *
    *******************
    */
    public function FirstStep(Request $request)
    {
        $validator = Validator::make($data = $request->all(), 
    	[
            'email'=>'required|email',
		]);
    	
		if($validator->fails()){
    		return response()->json(['status'=>'0','errors'=>$validator->errors()->all()]);
        }
        $find_user = User::where('email',$request->get('email'))
                    ->whereIn('type_user', array('user', 'salon', 'family'))
                    ->first();
        //Check user info 
        if(count($find_user) > 0){
            $generate_code = substr(md5(rand()),0,10);
            $token = md5(rand());
            
            $update_user = User::find($find_user->id)->update([
                'reset_code'=>$generate_code,
                'user_token'=>$token
            ]);
         Mail::send('email.reset_code', ['username'=>$find_user->name,'generate_code'=>$generate_code,'email'=>$find_user->email,'find_user'=>$find_user], function ($message) use ($find_user,$generate_code)
            {
               $message->from('no-reply@SalonX.com', 'Support.SalonX.com');
               $message->to($find_user->email)->subject('Forget password');
           });
           if($request->get('lang') == 'en'){
                return response()->json(['status'=>'1','success'=>'check your email!','token'=>$token]);
            }else{
                return response()->json(['status'=>'1','success'=>'تفقد بريدك الألكتروني!','token'=>$token]);                
            }
        }else{
            //user user info  if not found will see this message
            if($request->get('lang') == 'en'){
                return response()->json(['status'=>'2','error'=>'Email Not Found!']);
            }else{
                return response()->json(['status'=>'2','error'=>'بريد الكتروني غير موجود!']);                
            }
        }

    }
    /*
    ***************
    * Check Owner *
    ***************
    */ 
    public function VerificationCode(Request $request,$token)
    { 
        $validator = Validator::make($data = $request->all(), 
    	[
            'code'=>'required'
		]);
    	
		if($validator->fails()){
    		return response()->json(['status'=>'0','errors'=>$validator->errors()->all()]);
        }

        $find_user = User::where('user_token',$token)->first();

        if($find_user->reset_code == $request->get('code'))
        {
            $update_user = User::find($find_user->id)->update([
                'reset_code'=>'',
            ]);

            if($request->get('lang') == 'en'){
                return response()->json(['status'=>'1','accepted'=>'true value.. Congrats!','token'=>$token]);                
            }else{
                return response()->json(['status'=>'1','accepted'=>'قيمه صالحه .. تهانينا!','token'=>$token]);                
            }
           
        }else{
            if($request->get('lang') == 'en'){
                return response()->json(['status'=>'2','failure'=>'failure value.. sorry!']);                
            }else{
                return response()->json(['status'=>'2','failure'=>'قيمه خاطئه .. نأسف!']);                
            }
        }

    }

    /*
    ******************
    * Reset Password *
    ******************
    */
    public function ResetPassword(Request $request, $token)
    {
        $validator = Validator::make($data = $request->all(), 
    	[
            'password'=>'required|confirmed|min:8',
		]);
    	
		if($validator->fails()){
    		return response()->json(['status'=>'0','errors'=>$validator->errors()->all()]);
        }

        $find_user = User::where('user_token',$token)->first();
        $update_password  = User::find($find_user->id)->update([
            'password'=>bcrypt($request->get('password'))
        ]);

        if($request->get('lang') == 'en'){
            return response()->json(['status'=>'1','accepted'=>'password updated!']);                
        }else{
            return response()->json(['status'=>'1','accepted'=>'تم تحديث كلمة المرور !']);                
        }
    }

}

