<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\ServiceRequest;
use App\Service;
use Illuminate\Support\Facades\Session;
class ServicesController extends Controller
{
    public function index()
    {
        $services = Service::all();
        return view('admin.services.index',compact('services'));
    }
    public function create()
    {
        return view('admin.services.create');
    }

    public function store(ServiceRequest $request)
    {
    	$create = Service::create($request->all());
    
    	Session::flash('success','تم إضافة خدمه جديده');
    	return redirect()->back();
    }

    public function edit($id)
    {
        $info = Service::find($id);
        return view('admin.services.edit',compact('info'));
    }

    public function update(ServiceRequest $request,$id)
    {
        $data=$request->all();
        if ($request->menu=="on") {
$data['menu']='1' ;
    }else{
        $data['menu']='0' ;

    }
           if ($request->default=="on") {
$data['default']='1';   
    }else{
        $data['default']='0' ;

    }
    
        $update = Service::find($id)->update($data);
    
        Session::flash('success','تم تعديل البيانات بنجاح');
        return redirect()->back();
    }

    public function destroy($id)
    {
        Service::destroy($id);
        Session::flash('success','تم حذف الخدمه بنجاح..');
        return redirect()->back();
    }
}

