<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\PortfolioRequest;
use App\Portfolio,App\Service,App\ProjectImage;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
class PortfolioController extends Controller
{
    public function index()
    {
        $portfolios = Portfolio::all();
        return view('admin.portfolio.index',compact('portfolios'));
    }
    public function create()
    {
        $services = Service::all();
        return view('admin.portfolio.create',compact('services'));
    }

    public function store(PortfolioRequest $request)
    {
        
        $data=$request->all();
    	$create = Portfolio::create($data);
        
        if($request->hasFile('image')){
            $files = $request->file('image');
     
           foreach($files as $file) {
            $time = str_replace('/','5',str_replace('.','$',Hash::make(time())));
            $ext  = $file->getClientOriginalExtension();
            $fullname = $time . '.' . $ext;
            $file->move(public_path() .'/uploads/portfolio', $fullname);
            $path ='/uploads/portfolio';
             ProjectImage::create(['image' => $path.'/'.$fullname,'portfolio_id'=>$create->id]);
    
             }     
        }
       
         
    	Session::flash('success','تم إضافة عمل جديد ، تهانينا ;)');
    	return redirect()->back();
    }

    public function edit($id)
    {
        $info = Portfolio::find($id);
        $services = Service::all();

        return view('admin.portfolio.edit',compact('info','services'));
    }

    public function update(PortfolioRequest $request,$id)
    {
      
         $data=$request->all();
        if($request->hasFile('image')){
           $files = $request->file('image');
            
           foreach($files as $key=> $file) {
            $time = str_replace('/','5',str_replace('.','$',Hash::make(time())));
            $ext  = $file->getClientOriginalExtension();
            $fullname = $time . '.' . $ext;
            $file->move(public_path() .'/uploads/portfolio', $fullname);
            $path ='/uploads/portfolio';
           
             ProjectImage::create([
                 'image' => $path.'/'.$fullname,
                 'portfolio_id'=>$id
                 ]);
    
             }
        }
         
        $update = Portfolio::find($id)->update($data);
    
        Session::flash('success','تم تعديل البيانات بنجاح');
        return redirect()->back();
    }

    public function destroy($id)
    {
        Portfolio::destroy($id);
        Session::flash('success','تم حذف الخدمه بنجاح..');
        return redirect()->back();
    }
    
     public function destroyImage($id)
    {
        ProjectImage::destroy($id);
        Session::flash('success','تم حذف الصوره بنجاح..');
        return redirect()->back();
    }
}
