<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\OfferRequest;
use App\Offer;
use Illuminate\Support\Facades\Session;
class OffersController extends Controller
{
    public function index()
    {
        $offers = Offer::all();
        return view('admin.offers.index',compact('offers'));
    }
    public function create()
    {
        return view('admin.offers.create');
    }

    public function store(OfferRequest $request)
    {
    	$create = Offer::create($request->all());
    
    	Session::flash('success','تم إضافة الغرض بنجاح');
    	return redirect()->back();
    }

    public function edit($id)
    {
        $info = Offer::find($id);
        return view('admin.offers.edit',compact('info'));
    }

    public function update(OfferRequest $request,$id)
    {
        $update = Offer::find($id)->update($request->all());
    
        Session::flash('success','تم تعديل البيانات بنجاح');
        return redirect()->back();
    }

    public function destroy($id)
    {
        Offer::destroy($id);
        Session::flash('success','تم حذف العرض بنجاح..');
        return redirect()->back();
    }
}

