<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\HostRequest;
use App\Host;
use Illuminate\Support\Facades\Session;
class HostsController extends Controller
{
    public function index()
    {
        $hosts = Host::all();
        return view('admin.hosts.index',compact('hosts'));
    }
    
    public function create()
    {
        return view('admin.hosts.create');
    }

    public function store(HostRequest $request)
    {
    	$create = Host::create($request->all());
    
    	Session::flash('success','تم إضافة خدمه جديده');
    	return redirect()->back();
    }

    public function edit($id)
    {
        $info = Host::find($id);
        return view('admin.hosts.edit',compact('info'));
    }

    public function update(HostRequest $request,$id)
    {
        $update = Host::find($id)->update($request->all());
    
        Session::flash('success','تم تعديل البيانات بنجاح');
        return redirect()->back();
    }

    public function destroy($id)
    {
        Host::destroy($id);
        Session::flash('success','تم حذف الخدمه بنجاح..');
        return redirect()->back();
    }
}

