<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\ContactUs;
use App\ActivityLog;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\StreamedResponse;

class ExportController extends Controller
{
    public function exportContacts(Request $request)
    {
        $contacts = ContactUs::orderBy('created_at', 'desc')->get();
        
        ActivityLog::log('export', 'Exported contact submissions to CSV');
        
        $headers = [
            'Content-Type' => 'text/csv; charset=UTF-8',
            'Content-Disposition' => 'attachment; filename="contacts_' . date('Y-m-d_H-i-s') . '.csv"',
        ];
        
        $callback = function() use ($contacts) {
            $file = fopen('php://output', 'w');
            
            // Add BOM for UTF-8 Excel compatibility
            fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
            
            // Header row
            fputcsv($file, [
                'ID',
                'الاسم',
                'البريد الإلكتروني',
                'الهاتف',
                'العنوان',
                'الرسالة',
                'الخدمة',
                'تاريخ الإرسال',
            ]);
            
            // Data rows
            foreach ($contacts as $contact) {
                fputcsv($file, [
                    $contact->id,
                    $contact->name,
                    $contact->email,
                    $contact->phone,
                    $contact->title,
                    $contact->message,
                    $contact->service_id,
                    $contact->created_at->format('Y-m-d H:i:s'),
                ]);
            }
            
            fclose($file);
        };
        
        return new StreamedResponse($callback, 200, $headers);
    }
}
