<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\ContactUs;
use App\Http\Requests\Admin\ReplyContactRequest;
use Mail;
use Illuminate\Support\Facades\Session;

class ContactusController extends Controller
{
    public function index()
    {
	$infos = ContactUs::with('service')->orderBy('created_at','DESC')->paginate(50);
    return view('admin.contact_us.index',compact('infos'));
    }

    public function GetReply($id)
    {
	$info = ContactUs::find($id);
	 ContactUs::find($id)->update(['read'=>'1']);

    return view('admin.contact_us.reply',compact('info'));
    }

    public function PostReply(ReplyContactRequest $request)
    {
		$id = $request->get('id');
		$title = $request->get('title');
		$email = $request->get('email');
		$mms = $request->get('message');
	 ContactUs::find($id)->update(['reply'=>'1']);

		Mail::send('email.reply', ['title' => $title,'mms' =>$mms], function ($message) use ($email,$title)
			 {
			    $message->from('no-reply@bedayh4it.com', 'Support.bedayh4it.com');
			    $message->to($email)->subject($title);
			});
		$message_success = Session::flash('success','تم إرسال الرد للمستخدم');
		return redirect()->back();
    }

    public function destroy($id)
    {
    	ContactUs::destroy($id);
    	$message_success = Session::flash('success','تم حذف الطلب بنجاح');
		return redirect()->back();
    }
}
