<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Blog;
use Illuminate\Support\Facades\Session;

class BlogsController extends Controller
{
    public function __construct(
        Blog $model
	){
		$this->model = $model;
	}

	public function index()
	{

		$blogs =  $this->model->paginate(30);
//		dd($blogs);
		return view('admin.blog.index',compact('blogs'));
	}
	public function create()
	{
		return view('admin.blog.create');
	}

	public function store(Request $request)
	{
		$create = $this->model->create($request->all());
		Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	public function edit($id)
	{
		$info = $this->model->find($id);
		return view('admin.blog.edit',compact('info'));
	}

	public function update(Request $request,$id)
	{
		$this->model->find($id)->update($request->all());
//        dd($request->all());

        Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	public function destroy($id)
	{
		$this->model->destroy($id);
		Session::flash('success',trans('home.deleted_successfully'));
		return redirect()->back();
	}
}
