<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;

class ContactUsSetting extends Model
{
    protected $table = 'contactus_settings';
    protected $fillable = [
        'long',
        'lat',
        'address',
        'name',
        'email',
        'phone',
        'logo',
        'meta_tags',
        'fburl',
        'twitter_url',
        'google_url',
        'instgram_url',
        'youtube_url',
        'linkedin_url',
        'lat',
        'long',
        'description',
        'map'
    ];

    public function setLogoAttribute($logo): void
    {
        if ($logo instanceof UploadedFile && $logo->isValid()) {
            $time = time();
            $ext = $logo->getClientOriginalExtension();
            $fullname = $time . '.' . $ext;
            $logo->move(public_path('uploads/images/logo'), $fullname);
            $path = '/uploads/images/logo';
            $this->attributes['logo'] = $path . '/' . $fullname;
        } elseif (is_string($logo) && !empty($logo)) {
            $this->attributes['logo'] = $logo;
        }
    }
}
