<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Service;
use App\Blog;
use App\Portfolio;

class PopulateSeoFields extends Command
{
    protected $signature = 'seo:populate';
    protected $description = 'Populate SEO fields for existing content';

    public function handle()
    {
        $this->info('Populating SEO fields...');

        // Update Services
        $services = Service::whereNull('meta_title')->orWhere('meta_title', '')->get();
        foreach ($services as $s) {
            $s->meta_title = mb_substr($s->name . ' | بداية لتقنية المعلومات', 0, 70);
            $s->meta_description = mb_substr(strip_tags($s->details ?: $s->content ?: ''), 0, 160);
            $s->save();
        }
        $this->info('Services updated: ' . count($services));

        // Update Blogs
        $blogs = Blog::whereNull('meta_title')->orWhere('meta_title', '')->get();
        foreach ($blogs as $b) {
            $b->meta_title = mb_substr($b->title . ' | بداية لتقنية المعلومات', 0, 70);
            $b->meta_description = mb_substr(strip_tags($b->content ?: ''), 0, 160);
            $b->save();
        }
        $this->info('Blogs updated: ' . count($blogs));

        // Update Portfolio
        $portfolio = Portfolio::whereNull('meta_description')->orWhere('meta_description', '')->get();
        foreach ($portfolio as $p) {
            if (empty($p->meta_title)) {
                $p->meta_title = mb_substr($p->name . ' | بداية لتقنية المعلومات', 0, 70);
            }
            $p->meta_description = mb_substr(strip_tags($p->content ?: ''), 0, 160);
            $p->save();
        }
        $this->info('Portfolio updated: ' . count($portfolio));

        $this->info('SEO fields populated successfully!');
        return 0;
    }
}
