<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class FixImagePaths extends Command
{
    protected $signature = 'fix:image-paths';
    protected $description = 'Fix image paths by removing /public prefix from database records';

    public function handle()
    {
        $this->info('Fixing image paths in database...');
        
        $tables = [
            'contactus_settings' => ['logo'],
            'about_us' => ['file', 'image'],
            'blogs' => ['image'],
            'services' => ['image', 'main_image'],
            'project_images' => ['image'],
            'sliders' => ['image'],
            'testmonials' => ['image'],
            'offers' => ['image'],
        ];
        
        foreach ($tables as $table => $columns) {
            if (!DB::getSchemaBuilder()->hasTable($table)) {
                $this->warn("Table {$table} does not exist, skipping...");
                continue;
            }
            
            foreach ($columns as $column) {
                if (!DB::getSchemaBuilder()->hasColumn($table, $column)) {
                    $this->warn("Column {$column} does not exist in {$table}, skipping...");
                    continue;
                }
                
                $updated = DB::table($table)
                    ->where($column, 'LIKE', '/public/%')
                    ->update([
                        $column => DB::raw("REPLACE({$column}, '/public/', '/')")
                    ]);
                
                if ($updated > 0) {
                    $this->info("Updated {$updated} records in {$table}.{$column}");
                }
            }
        }
        
        $this->info('Done! Image paths have been fixed.');
        return 0;
    }
}
