<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;

class Blog extends Model
{
    protected  $table= 'blogs';
    protected  $fillable = [
            'title',
            'meta_title',
            'meta_description',
            'content',
            'keywords',
            'image',
    ];

    public function setImageAttribute($image): void
	{
		if ($image instanceof UploadedFile && $image->isValid()) {
			$time = time();
			$ext = $image->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
			$image->move(public_path('uploads/images/blogs'), $fullname);
			$path = '/uploads/images/blogs';
			$this->attributes['image'] = $path . '/' . $fullname;
		} elseif (is_string($image) && !empty($image)) {
			$this->attributes['image'] = $image;
		}
	}
}
