<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\UploadedFile;

class AboutUs extends Model
{  
    protected $table = 'about_us';
    protected $fillable = [
        'content_ar','content_en','file','url','story','mission','vision','we_help',
    ];

    public function setFileAttribute($file): void
	{
		if ($file instanceof UploadedFile && $file->isValid()) {
			$time = time();
			$ext = $file->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
			$file->move(public_path('uploads/images/aboutus/files'), $fullname);
			$path = '/uploads/images/aboutus/files';
			$this->attributes['file'] = $path . '/' . $fullname;
		} elseif (is_string($file) && !empty($file)) {
			$this->attributes['file'] = $file;
		}
	}
}
